# Début programme de démonstration des sorties tout-ou-rien

# Ce programme met la broche D13 (13) a 1 (5V) et 0 (0V) successivement
# Un témoin LED sur Plug'Uno/Arduino est connecté a D13

from time import sleep

# Nous importons le seul élément Arduino de pyfirmata2Ext
from pyfirmata2Ext import Arduino

################################
# Communication avec Plug'Uno
################################
# Instanciation d'un objet représentant la carte Plug'Uno.
# Arduino.AUTODETECT peut être remplacé par l'identifiant de port-série (ex : "COM1").
# Arduino.AUTODETECT peut ne pas fonctionner correctement avec les port-serie Bluetooth.
plugUno = Arduino(Arduino.AUTODETECT)
#plugUno = Arduino(input("Saisir le port de communication COM1, COM2, COM3 .... :"))

################################
# Configuration des E/S
################################
brocheLED = plugUno.get_pin('d:13:o')
# -> d  : signifie mode numerique/digital
# -> 13  : numéro de la broche (2/3/4/5/6/7/8/9/10/11/12/13)
# -> o  : mode sortie/output (push-pull)

################################
# Utilisation
################################
# Definir l'etat Haut/Bas de la broche
#brocheLED.write(0) # 0 pour niveau Bas ou 0V
#brocheLED.write(1) # 1 pour niveau Haut ou 5V

# Faire clignoter 100 fois la LED relié a D13
for i in range(100) :
    brocheLED.write(1)
    sleep(.02)
    brocheLED.write(0)
    sleep(.02)

# Fermer la connection a Plug'Uno avant de quitter.
plugUno.exit()

# Met fin a l'exécution du programme Python.
#exit()

# Fin programme de démonstration des sorties tout-ou-rien
